package jamezo97.clonecraft.network;

import jamezo97.clonecraft.dna.GeneTeleport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import cpw.mods.fml.relauncher.Side;

public class Handler18TPEffects extends Handler{
	@Value(id = 0)
	double xf;

	@Value(id = 1)
	double yf;

	@Value(id = 2)
	double zf;
	
	@Value(id = 3)
	double xt;

	@Value(id = 4)
	double yt;

	@Value(id = 5)
	double zt;
	
	@Value(id = 6)
	int entityId;

	public Handler18TPEffects() {
		
	}
	
	public Handler18TPEffects(double xf, double yf, double zf, double xt, double yt, double zt, EntityLivingBase e) {
		
		this.entityId = e.entityId;
		this.xf = xf;
		this.yf = yf;
		this.zf = zf;
		this.xt = xt;
		this.yt = yt;
		this.zt = zt;
	}

	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(player.worldObj.isRemote){
			Entity e = this.getEntityOnClient(entityId);
			if(e != null && e instanceof EntityLivingBase){
				if(e == player){
					e.setPosition(xf, yf, zf);
					e.lastTickPosX = xf;
					e.lastTickPosY = yf;
					e.lastTickPosZ = zf;
				}
				System.out.println(String.format("%s, %s, %s",xf, yf, zf));
				GeneTeleport.makeTPEffects((EntityLivingBase)e, xf, yf, zf, xt, yt, zt);
			}
			
		}
	}

}
